using System;

class Program
{
    static void Main()
    {
        string[] input = Console.ReadLine().Split();
        int N = int.Parse(input[0]);
        int K = int.Parse(input[1]);

        double[][] runners = new double[N][];
        for (int i = 0; i < N; i++)
        {
            string[] runnerInfo = Console.ReadLine().Split();
            runners[i] = new double[] { double.Parse(runnerInfo[0]), double.Parse(runnerInfo[1]) };
        }

        double low = 0;
        double high = 1e9; // 10^9
        double answer = -1;

        while (high - low > 1e-9) 
        {
            double mid = (low + high) / 2;

            if (possible(runners, mid, K))
            {
                answer = mid;
                high = mid;
            }
            else
            {
                low = mid;
            }
        }

        Console.WriteLine($"{answer:F9}");
    }

    static bool possible(double[][] runners, double time, int K)
    {
        int count = 0;

        for (int i = 0; i < runners.Length; i++)
        {
            double finalPos = runners[i][0] + time * runners[i][1];
            for (int j = i + 1; j < runners.Length; j++)
            {
                double finalPosNext = runners[j][0] + time * runners[j][1];
                if (finalPos < finalPosNext)
                    count++;
            }
        }

        return count >= K;
    }
}